function pc_grid_horizontal($array, $size) {

    // oblicz procentowe szerokoci <td>
    $table_width = 100;
    $width = intval($table_width / $size);

    // zdefiniuj sposb wywietlania znacznikw <tr> i <td>
    // sprintf() wymaga zastosowania %%, aby wywietli znak %
    $tr = '<tr align="center">';
    $td = "<td width=\"$width%%\">%s</td>";

    // otwrz tabel
    $grid = "<table width=\"$table_width%\">$tr";

    // iteruj przez pozycje i wywietlaj je w wierszach o rozmiarze $size
    // $i kontroluje, kiedy trzeba utworzy nowy wiersz
    $i = 0;
    foreach ($array as $e) {
        $grid .= sprintf($td, $e);
        $i++;

        // koniec wiersza
        // zamknij go i otwrz nowy
        if (!($i % $size)) {
            $grid .= "</tr>$tr";
        }
    }

    // wypenij pozostae komrki pustymi znakami
    while ($i % $size) {
        $grid .= sprintf($td, '&nbsp;');
        $i++;
    }

    // jeli trzeba, dodaj </tr>
    $end_tr_len = strlen($tr) * -1;
    if (substr($grid, $end_tr_len) != $tr) {
        $grid .= '</tr>';
    } else {
        $grid = substr($grid, 0, $end_tr_len);
    }

    // zamknij tabel
    $grid .= '</table>';

    return $grid;
}
